'AutoSave
' SB7GHZ
' Stellar Battle in the Seven Green Hills Zone by Vegipete 2022
' PicoMite VGA version - recommend version 5.07.05b15 or later
'   changes for PicoMiteVGA:
'   -Mode 2 - 320x240 resolution, 16 colours
'   -Lots of page/framebuffer changes
'      needs recent firmware for 3D Engine and FRAMEBUFFERS
'   -Atari (switched) joystick in PicoGAME-Mini (Port A of PicoGAME)
'      1   GP0   Up
'      2   GP1   Down
'      3   GP2   Left
'      4   GP3   Right
'      5   GP26  n.c.
'      6   GP14  Fire / Trigger
'      7   3V3   3V3
'      8   GND   GND
'      9   GP27  n.c.
'      Joystick processing routine is at very end of program
'   -Keys pressed on the console (arrows & SPACE) work, but not well.

'option angle degrees - not valid on PicoMite!
'additional Sound for Pico by M. Herhaus
Option default integer

' configure pins used for joystick
SetPin gp0,din
SetPin gp1,din
SetPin gp2,din
SetPin gp3,din
SetPin gp14,din

MODE 2:CLS  ' 320x240x16 colour
Font 7  ' 6x8
Const TANKSPEED=15
Const SHOTSPEED=150
Const ARENASIZE=6E4
Const BLASTRADIUS=5E4
Const MMHQ = MM.HRes/4
Const ASSETCOUNT=20

' object array holds all the items in the arena:
'  0) player-unused
'  1) player shot 1
'  2) player shot 2
'  3) enemy shot 1
'  4) enemy shot 2
'  5) fuel bay
'  6) stargate
'  7) enemy 1
'  8) enemy 2
'  9-20) obstacles
'  -------
'  0) exists
'  1) x position
'  2) y position
'  3) angle
'  4) velocity    (shot: dx)
'  5) (shot velocity: dy)
'  6) type: 1=shot, 2=pyramid, 3=cube, 4=fuel, 5=stargate, 6=tank1, 7=tank2
Dim object(ASSETCOUNT,6)
Dim distaway(ASSETCOUNT),distindx(ASSETCOUNT) ' for drawing objects far to near
Dim radar(ASSETCOUNT,2)   ' blips on radar: x,y,colour

Dim ctable(8)=(&hA52A2A,65280,33023,32768,16384,0,&h80FF,&hFF00C0,&h404040)
Dim hills(18)=(0,3,7,2,9,3,6,2,8,12,9,1,6,2,9,3,6,1,0) ' fold this into 3D data
Dim noise(255):For i =1 To 255:noise(i)=Int(Rnd*1000):Next
Dim fv(64),fcnt(20),ecol(20),fcol(20)
Dim s(200)    ' longstring for holding 3D object data for decoding
Dim t(9)      ' tank AI counters
Dim float head,fuel,shield,v(2,32),ct,st,q(4)

' 3D object data - carefully compressed
' Two big compression techniques:
' 1) numbers compressed into ascii codes, where "A"=0 (no commas, single byte per value)
' 2) entire repeated data array can be skipped
'    For example, the pyramid obstacles have chopped off tops, so data-wise, they are
'    identical to the cubes. Only the the actual vertex coordinates are unique between
'    the two object. All the other arrays can be rpresented by a single 'repeat' byte.
LA "EEDDDDHAAAHAAA>CAAHADCAAEJJLABCCBDBADACDIFEEEEEEEEEEDDDDD8A8JA8JAJ8AJ@S@BS@B"
LA "SB@SBNTAEFBBFGCCGHDDHEAHGFEIF!!!=A=EA=EAE=AE=I=EI=EIE=IEZANKEEEEEEDDDDEEEEEE"
LA "BBBBAAAAACBBBB<A<FA<FAF<AF?B?CB?CBC?BC>G>DG>DGD>GDAIAUdAEFBBFGCCGHDDHEAHGFEI"
LA "JKLIMJJMKKMLLMINK!EEEEEEGGGGGGGGBBDDDD@A@BA@BAB@AB?M?CM?CMC?MCAM7GMAAMK;MAAQ"
LA "AKALIDDDDEEEDEEEEEEEEBBBBCCCEDA9DAI>AI>A9AF:BD@BEJ@EJ@D@AE=AFJU[AEBBECCEDADE"
LA "FGHIFJKGIHKJGKHPNEEEEEDDDDEEEDEEEEEEEEEEEEEEDDDDCCCCBBBEDA9DAJ>AJ>A9ED8EDK=D"
LA "K=D8AH;BFCBGK@GK@FCAG?AHKPoABCDAEFBBFGCCGHDADHEEIFFIGGIHHIEJKLMJNOKMLONKOL  "
k=1
Do
  nv=NB() ' read number of vertices for next object
  If nv<-32 Then Exit
  nf=NB() ' read number of faces
  RC(fcnt())  ' read number of vertices for each face
  RC(ecol())  ' read colour of edge of each face
  RC(fcol())  ' read colour of each face
  For j=0To nv-1:v(0,j)=NB():v(1,j)=NB():v(2,j)=NB():Next ' read vertex coordinates
  sc=NB():Math scale v(),sc,v() ' read and scale vertex cloud
  tot=NB()  ' total number of vertices of faces, skip if 0 (no change)
  If tot Then For j=0To tot:fv(j)=NB():Next  ' vertices for each face
  Draw3D create k,nv,nf,1,v(),fcnt(),fv(),ctable(),ecol(),fcol()
  Inc k
Loop
For i=1To 8:Read object(i,6):Next :Data 1,1,1,1,4,5,6,7 ' object types
FRAMEBUFFER create 'PW 3
FRAMEBUFFER write F
CLS

' paint ringed planet sprite - well, no, not yet.
'circle MM.HRES/2,MM.VRES/2,11,,4,ctable(2),ctable(2)    ' rings OD
'circle MM.HRES/2,MM.VRES/2, 7,,4,0,0                    ' rings ID
'blit read 8,MM.HRES/2-30,MM.VRES/2,60,30                   ' store rings in front of planet
'circle MM.HRES/2,MM.VRES/2,30,,,ctable(3),ctable(3)     ' draw planet
'blit write 8,MM.HRES/2-30,MM.VRES/2,4                      ' restore rings in front of planet
''image rotate 150,100,100,100,150,100,15     ' rotated looks cooler
'blit read 1,315,268,170,64                  ' save ringed planet image for later use

' Start a new game
head=0       ' player heading
fuel=99
shield=99
level=1
demo=0    ' demo mode on to start
'wpage=0   ' page flipping
newpress=1

' bigger zoom=narrower field of view : zoom in
' 500 is approx 90 degrees (on CMM2, mode 1)
zoom=200    ' approx 90 degrees on PicoMiteVGA mode 2
Draw3D camera 1,zoom,0,75

MakeObstacles

SetTick 25,MM,1   ' start timer interrupt for sound and shield repair

Do
  ' test for key presses
  k = Asc(Inkey$)
  If k Then ServiceKey k    ' found a key in the console buffer?

  ReadJoystick

  ' MODIFIER pressed-create a new shot of there is none and hasn't been one for a while
  If shotpress Then
    If newpress Then
      newpress=0  ' edge select the keypress so only one shot is created
      For i=1To demo*2
        If object(i,0)=0 Then v2=25:NewShot(i,0,0,-head):i=3   ' force loop to end
      Next
    EndIf
    shotpress = 0
  Else
    newpress=1
  EndIf

  ' move various objects
  ' 1) move shots, test for hits
  For i=1To 4
    If object(i,0)Then  ' shot exists
      Inc object(i,0),-Sgn(object(i,0))  ' shot expires after a while
      target = MoveBlocked(i,7,object(i,4),object(i,5))  ' shot hits something
      If target>6 Then  ' hit an enemy tank or an obstacle
        object(i,0)=-object(i,0)          ' shot gone
        If target<9 Then                  ' hit an enemy tank
          v1=75                           ' play explosion sound
          object(target,1)=ARENASIZE/2    ' new tank x-coord
          object(target,2)=ARENASIZE/target   ' new tank y-coord
          object(target,3)=Rnd*360        ' new tank angle
          Inc score,demo                  ' no score increase in demo mode
          If score>level*9 And object(6,0)=0 Then v4=99:object(6,0)=1   ' stargate appears
        EndIf
      EndIf
    EndIf
  Next
  ' 2) stargate slowly turns
  Inc object(6,3),1
  ' 3) enemies turn towards player and move
  TurnEnemy(7)
  TurnEnemy(8)
  ' 4) slowly turn view if in demo mode
  If demo=0 Then head=head+1/5
  ' 5) keep heading in range (0,360]
  If head>360 Then head=head-360   ' can't use MOD because we loose the decimal part
  If head<0 Then head=head+360

  ' Test for game over
  If shield<0 Then
    FRAMEBUFFER write N  ' PW 0
    For i = 0 To 999
      Line 0,600*Rnd,800,600*Rnd,,ctable(0)
      Pause 2
    Next
    Text MM.HRes/2,MM.VRes/2,"GAME OVER",CT,3,,ctable(0)
    Pause 4000
    demo=0  ' back to demo mode
    shield=99
    NewLevel
  EndIf

  ' draw scene
  FRAMEBUFFER write F
  DrawScene
  If qx+qy Then Sprite scroll qx,qy:qx=0:qy=0   ' shake screen if hit

  ' wait for framerate, then display
  Do : Loop Until Timer>25
  Timer =0
  FRAMEBUFFER copy F,N,B  ' copy frame buffer to display on next VBL
Loop

End

'==================
Sub ServiceKey(k)
  ' space bar to end demo mode
  If k+demo=32 Then head=0:level=1:demo=1:score=0:NewLevel:End Sub

  ' SPACE BAR = new shot
  shotpress = (k=32)

  ' turn left or right if not demo mode
  head = (head+360+((k=131)-(k=130))*demo)Mod 360

  ' move forward or reverse
  MoveForward 50*((k=128)-(k=129))
End Sub

'==================
' Since the camera can't move, everything else must move instead
' Move forward requested distance in direction we are facing,
' unless blocked by items 7 thru 20.
' Handle encounters with fuel bay and star gate
Sub MoveForward(dist)

  If fuel<0 Or dist*demo=0 Then Exit Sub   ' no gas left, no distance or demo mode
  fuel=fuel-(fuel>0)/200   ' burn more fuel while moving
  dx=Sin(Rad(head))*dist
  dy=Cos(Rad(head))*dist

  i = MoveBlocked(0,5,dx,dy)  ' player try to move forward
  If i<6 Then  ' move forward and clamp into the arena
    For i=1To ASSETCOUNT:Clamp2Arena(object(i,1),-dx):Clamp2Arena(object(i,2),-dy):Next
  ElseIf i=6 Then  ' drive thru star gate?
    FRAMEBUFFER write N ' draw stargate effect direct on main screen
    For i=1To 999
      n=Rnd*360
      Line MM.HRes/2,MM.VRes/2,MM.HRes/2+500*Sin(Rad(n)),MM.VRes/2+500*Cos(Rad(n)),,&hFFFF
      Pause 1
    Next
    head=(head+180)Mod 360  ' turn 180 degrees to start next level
    Inc level
    NewLevel
  Else
    v3=-2             ' bump sound
    shield=shield-1   ' damage from crashing into something
  EndIf
End Sub

'==================
' create a new shot
Sub NewShot(n,x,y,h)
  object(n,0)=90*demo  ' shot duration
  object(n,1)=x
  object(n,2)=y
  object(n,3)=h
  object(n,4)=-Sin(Rad(h))*SHOTSPEED  ' dx
  object(n,5)= Cos(Rad(h))*SHOTSPEED  ' dy
  snd%=1:NV=100
End Sub

'==================
Sub Clamp2Arena(c,d):c=(c+d+1.5*ARENASIZE)Mod ARENASIZE-ARENASIZE/2:End Sub

'==================
' Can object n move dx,dy?  n is 0,1,2,3,4,7,8
' Test against selectable other objects  (, except fuel bay)
Function MoveBlocked(n,f,dx,dy)
  'local x,y,j
  MoveBlocked=1
  x=object(n,1):Clamp2Arena(x,dx)
  y=object(n,2):Clamp2Arena(y,dy)

  ' enemy tank can't drive through player
  If n>6 And x^2+y^2<BLASTRADIUS Then Exit Function

  For j=f To 20
    j=j+(j=n)+(n+4=j)  ' tank can't block or shoot itself
    If (object(j,1)-x)^2+(object(j,2)-y)^2<BLASTRADIUS Then MoveBlocked=j:Exit Function
  Next
  MoveBlocked=0
  If n Then object(n,1)=x:object(n,2)=y ' update position if not blocked
End Function

'==================
' Create and display a new level
Sub NewLevel
  MakeObstacles
  FRAMEBUFFER close     ' close the framebuffer (not enough memory for both)
  FRAMEBUFFER layer     ' create the overlay layer
  FRAMEBUFFER copy N,L  ' copy whatever is currently visible to the top layer
  FRAMEBUFFER write N   ' draw on the main screen
  DrawScene
  ' open iris new world over star travel spray
  FRAMEBUFFER write L   ' erase star travel spray which is on overlay
  For i =1 To MM.HRes/2
    Box MM.HRes/2-i,MM.VRes/2-i,i*2,i*2,3,&hFFFF,0
    Pause 200/i
  Next
  FRAMEBUFFER close     ' done with overlay layer
  FRAMEBUFFER create    ' recreate the framebuffer
  FRAMEBUFFER write L
End Sub

'==================
Sub TurnEnemy(n)
  Local h,te

  ' busy with obstacle avoidance turn?
  If t(n)Then Inc t(n),-Sgn(t(n)):object(n,3)=(object(n,3)+Sgn(t(n))*2)Mod 360:Exit Sub
  ' adjust angle towards origin
  te = Deg(Atan2(object(n,1),-object(n,2)))
  Inc te,360*(te<0)  ' direction toward origin/player
  h = (object(n,3)-te)Mod 360

  ' shoot if aimed at origin/player and no shot in flight
  If h=0 And object(n-4,0)=0 Then NewShot(n-4,object(n,1),object(n,2),object(n,3))
  te=-Sgn(h)
  If Abs(h)>180 Then te=-te 'NG te
  object(n,3)=(object(n,3)+te)Mod 360  ' new enemy heading

  ' enemy try to move forward
  If MoveBlocked(n,5,-Sin(Rad(object(n,3)))*object(n,4),Cos(Rad(object(n,3)))*object(n,4))Then
    ' can't move that way, so start a random turn left or right
    t(n)=60*Sgn(Rnd-.5)
  EndIf
End Sub

'==================
' Create a bunch of objects
Sub MakeObstacles
  'local i

  For i=1To 4:object(i,0)=0:PositionItem(i+4):Next  ' clear shots, create FB,SG, enemy tanks

  object(7,4)=TANKSPEED*2 + 2*level  ' speedy!
  object(8,4)=TANKSPEED + 2*level

  For i=9To ASSETCOUNT
    PositionItem(i)
    object(i,6)=2 + (Rnd<.5)  ' assume it's a pyramid to start, randomly change to cube
  Next
End Sub

'==================
Sub PositionItem(n)
  Local  x,y

  object(n,0)=(n<>6)    ' items visible except star gate not visible at start
  Do
    x=Rnd*ARENASIZE-ARENASIZE/2
    y=Rnd*ARENASIZE-ARENASIZE/2
  Loop While x^2 + y^2<4E6
  object(n,1)=x  ' x position
  object(n,2)=y  ' y position
  object(n,3)=Rnd*360  ' angle

End Sub

'==================
' test player has been hit by enemy shot n
Sub PlayerHit(n)
  If object(n,0)>0 Then
    object(n,0)=-object(n,0)
    Inc shield,-5*demo
    qx=Rnd*10-5 ' wiggle the screen image
    qy=Rnd*10-5

    v3=-3
  EndIf
End Sub

'==================
' Draw background and all the visible 3D objects, from farthest to nearest
' image gets drawn on currently active layer
Sub DrawScene
  Local i,n,ix,j

  ' calculate distance to each item
  For i=1To ASSETCOUNT:distaway(i)=object(i,1)^2+object(i,2)^2:Next

  ' test if player hit by enemy shot
  For i=3To 4:If distaway(i)<BLASTRADIUS Then PlayerHit(i)
  Next

  fuel=fuel-demo*(fuel>0)/200  ' use up fuel
  ' sitting in fuel bay?
  If distaway(5)<BLASTRADIUS Then fuel=100:shield=Min(100,shield+sr/500):sr=0

  Sort distaway(),distindx(),1  ' sort farthest to nearest (descending distance)

  ct=Cos(Rad(head))
  st=Sin(Rad(head))

  'framebuffer write F   ' PW wpage+1
  CLS
  Line 0,MM.VRes/2,MM.HRes,MM.VRes/2,1,ctable(3)  ' horizon line

  'if head>239 and head<340 then blit write 1,3100-head*9.6,MM.VRES/10  ' Saturn
  Circle MM.HRes-head*3.84,MM.VRes/4,10,0,1,,ctable(3)  ' moon
  Circle MM.HRes-head*3.84-3,MM.VRes/4+1,10,0,1,,0      ' change it to a crescent
  Circle MM.HRes*2-head*3.84,MM.VRes/10,15,0,1,,RGB(128,255,0) ' sun

  ' draw those dear green hills
  ix=(head-.49)\20       ' index at center (0.49 for rounding reasons)
  n=-head*4 Mod MMHQ     ' = MM.HRES/4
  For i=0To 5
    j=(ix+i+15)Mod 18
    Line n,MM.VRes/2-hills(j)*5,n+MMHQ,MM.VRes/2-hills(j+1)*5,,ctable(3)
    n=n+MMHQ
  Next

  Math set 0,radar()  ' clear all blips from radar screen
  For i=1To ASSETCOUNT
    n=distindx(i)

    If object(n,0)>0 Then  ' exists/visible

      ' revolve items
      x=object(n,1)*ct - object(n,2)*st
      y=object(n,1)*st + object(n,2)*ct

      ' save blip to radar image data
      radar(i,0) = x * 70 / ARENASIZE
      radar(i,1) = y * 70 / ARENASIZE
      radar(i,2) = 6*(object(n,6)=5)+(object(n,6)=4)  ' stargate in blue, fuel bay in green

      ' draw the 3D object
      ' min 220 to avoid drawing bug?
      If y>160 And Abs(x)<y Then
        Math q_euler Rad(object(n,3)+(head)),0,0,q()
        Draw3D rotate q(),object(n,6)
        Draw3D write object(n,6),x,0,y
      EndIf
    EndIf
  Next

  ' draw the radar image
  Box MM.HRes/2-12,MM.VRes-54,53,53,1,RGB(grey),0 'redraw frame
  For i=1To ASSETCOUNT  ' draw radar image
    If Abs(radar(i,0)) < 26 And Abs(radar(i,1)) < 26 Then
      Pixel MM.HRes/2+14+radar(i,0),MM.VRes-28-radar(i,1),ctable(radar(i,2))
    EndIf
  Next
  Pixel MM.HRes/2+14,MM.VRes-28,RGB(yellow)   ' player in center

  ' draw headings and stuff
  Text MM.HRes/2,6,"LEVEL:"+Str$(level,2)+"  SCORE:"+Str$(score,3),CT,,,ctable(1),-1
  Text MM.HRes/2,MM.VRes-55,"S F  HEADING: "+Str$(head,3,0),CB,,,ctable(1),-1
  DrawGauge(MM.HRes/2-54,shield)
  DrawGauge(MM.HRes/2-42,fuel)
  If demo=0 Then Text MM.HRes/2,MM.VRes/4,"[FIRE] to Play",CB,3,,ctable(1),-1

  ' erase effects of drawing routine bug
  Line 0,0,0,MM.VRes,1,0
  Line MM.HRes-1,0,MM.HRes-1,MM.VRes,1,0
End Sub

' Draw gauge to show shield or fuel
Sub DrawGauge(x,g)
  Box x,MM.VRes-53,10,52,1,&h404040,0
  If g>0 Then Box x+1,MM.VRes-3-g/2,8,g/2,4,ctable(g>25)
End Sub

' Read an array of data, or leave previous untouched
Sub RC(c())
  Local j,tmp
  tmp=NB():If tmp<>-32 Then c(0)=tmp:For j=1To nf-1:c(j)=NB():Next
End Sub

' Read next byte from data string
Function NB()
  Static n:NB=LGetByte(s(),n)-65:Inc n
End Function

' Build lonstring of data
Sub LA z$
  LongString append s(),z$
End Sub

' Timer interrupt
Sub MM  'fade out sound
'MH
If snd%=1 Then SetTick 1,noise_tick,2:SetTick 5,noise_vol,3
'
' Sorry, no sound for now because noise type isn't supported
  'play sound 1,b,n,99,v1/3
  v1=v1-(v1>0)  ' decrease volume of explosion sound
  'play sound 2,b,p,99-v2,v2
  v2=v2-(v2>0)  ' decrease volume of shot sound
  'play sound 3,b,n,200,20*(v3<>0)
  v3=v3+(v3<0)
  'play sound 4,b,t,499-99*sin(rad(v4)),v4/4
  v4=v4-(v4>0)  ' star gate appearing
  Inc sr  ' shield repair

End Sub

' changess by M. Herhaus---
Sub noise_tick
Play tone Noise(ns%),noise(ns%)
Inc ns%: ns%=ns% And 255
End Sub
Sub noise_vol
Play VOLUME nv,nv
Inc nv,-1
If nv=0 Then Play stop:SetTick 0,0,2:SetTick 0,0,3:snd%=0
Exit Sub

'=============

' Read and handle joystick inputs
' Modify to suit your hardware
' Joystick commands are converted to equivalent keystrokes
Sub ReadJoystick
  If Not Pin(gp0)  Then   ' forward     all are active low
    ServiceKey(128)
  EndIf
  If Not Pin(gp1)  Then   ' backward    0 - do something
    ServiceKey(129)
  EndIf
  If Not Pin(gp2)  Then   ' turn left   1 - do nothing
    ServiceKey(130)
  EndIf
  If Not Pin(gp3)  Then   ' turn right
    ServiceKey(131)
  EndIf
  If Not Pin(gp14) Then   ' fire
    If demo Then  ' in game mode so try create a new shot
      shotpress=1
    Else  ' in demo mode, so start a new game
      head=0:level=1:demo=1:score=0:NewLevel
    EndIf
  EndIf
End Sub
                                                                                 